<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Ticket extends Model 
{

    protected $table = 'tickets';
    public $timestamps = true;
    protected $fillable = array('title', 'body', 'client_id', 'service_id', 'status', 'user_id');

    public function ticketReplies()
    {
        return $this->hasMany('App\Models\TicketReplay');
    }

    public function client()
    {
        return $this->belongsTo('App\Models\Client');
    }

}